using System;
using System.IO;
using System.Diagnostics;
using System.Runtime.Remoting;

using Team_Project.PersistencyManagers.Protocols;

namespace Team_Project.PersistencyManagers.Storages
{
	public class LocalRemoteStorage : MarshalByRefObject, IStorage
	{
		protected IDistribuitedPersistencyProtocol protocol;
		protected string callerName;

		public LocalRemoteStorage(string Project,string sourceCopyName)
		{
		}
		#region IStorage Members
		private int num = 1;
		
		private void Call()
		{
			Trace.WriteLine("LRM: Call #" + num.ToString());
			num++;
		}

		public Stream OpenRead(string Location, string Name)
		{
			Call();
			return local.OpenRead(Location, Name);
		}

		public Stream OpenWrite(string Location, string Name)
		{
			Call();
			return local.OpenWrite(Location, Name);
		}

		public bool LocationExists(string Location)
		{
			Call();
			return local.LocationExists(Location);
		}

		public bool Exists(string Location, string Name)
		{
			Call();
			return local.Exists(Location,Name);
		}

		public string[] ElementsIn(string Location)
		{
			Call();
			return local.ElementsIn(Location);
		}

		public void CreateLocation(string Location)
		{
			Call();
			local.CreateLocation(Location);
		}

		public void DestroyLocation(string Location, bool checkEmpty)
		{
			Call();
			local.DestroyLocation(Location,checkEmpty);
		}

		public void Delete(string Location, string Name)
		{
			Call();
			local.Delete(Location,Name);
		}

		#endregion
	}


	public class RemoteStorageFactory: MarshalByRefObject
	{
		public RemoteStorageFactory()
		{}

		public IStorage BuildStorage(string project, string sourceOfCall)
		{
			return new LocalRemoteStorage(project,sourceOfCall);
		}
	}
}
